﻿Function Compare-XML
{
  param(
    [String]$XmlFile1,
    [String]$XmlFile2,
    [string]$ResultFile,
    [string]$DiffDataGramPath = ( "$env:TEMP\DataDiff.xml" )
  )
  
  Add-Type -Path "$PSScriptRoot\xmlDiff\xmldiffpatch.dll"
  $XmlDiff = New-Object -TypeName Microsoft.XmlDiffPatch.XmlDiff
  Add-Type -Path "$PsScriptroot\xmlDiff\XmlDiffPatch.View.dll"
  $XmlDiffView = New-Object -TypeName Microsoft.XmlDiffPatch.XmlDiffView
  
  $HtmlHeader = @"
<html><body>
<p><b>Legend:</b> 
<font style='background-color: yellow' color='black'> added</font>
&nbsp;&nbsp;<font style='background-color:red' color='black'>removed</font>
&nbsp;&nbsp;<font style='background-color:lightgreen' color='black'>changed</font>&nbsp;&nbsp;
<font style='background-color: red' color='blue'>moved from</font>
&nbsp;&nbsp;<font style='background-color: yellow' color='blue'>moved to</font>&nbsp;&nbsp;
<font style='background-color: white' color='#AAAAAA'>ignored</font>
</p>
<table width='100%'>
<tr><td colspan='2' align='center'>
"@

  $HtmlFooter = @"
</table></body></html>
"@
  
  #create XmlWriter object with path where to create the resulting XML file
  $DiffGramWriter = [System.Xml.XmlWriter]::Create( $DiffDataGramPath )
  #call Compare method from Microsoft.XmlDiffPatch.XmlDiff object 
  $XmlDiff.Compare($XmlFile1,$XmlFile2,$false,$DiffGramWriter)
  $DiffGramWriter.Close()
  
  $Orig = [System.Xml.XmlTextReader]::Create($XmlFile1)
  $DiffGram = [System.Xml.XmlTextReader]::Create($DiffDataGramPath)
  $StreamWriter = New-object -TypeName System.IO.StreamWriter -ArgumentList $ResultFile
  $XmlDiffView.Load($Orig,$DiffGram)
  
  $StreamWriter.Write($htmlHeader)
  $XmlDiffView.GetHtml($StreamWriter)
  $StreamWriter.Write($HtmlFooter)
  $StreamWriter.Close()
  $Orig.Close()
  $DiffGram.Close()  
}